/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <aauto/AditEndpointCommon.h>
#include "DummyMediaPlaybackStatus.h"

LOG_DECLARE_CONTEXT(aauto_media_pb_status);

using namespace adit::aauto;

#ifndef COMP_GIT_VERSION
#define COMP_GIT_VERSION "aauto_r3_d01 or newer"
#endif

AditMediaPlaybackStatus* DummyMediaPlaybackStatusCreate(uint8_t inId,
        MessageRouter* inRouter)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_media_pb_status, "MessageRouter pointer is null"));
        return nullptr;
    }

    return new DummyMediaPlaybackStatus(inId, inRouter);
}

/*
 * In case the library is linked at compile time it is more convenient to call
 * unique functions rather than the generic plug-in versions.
 */

void MediaPlaybackStatusEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    LOG_REGISTER_CONTEXT(aauto_media_pb_status, "MEDS", "AAUTO media playback status");
    LOGD_DEBUG((aauto_media_pb_status, "aauto-test-media-pb-status git tag: %s",
            COMP_GIT_VERSION));

    if (inFactoryRegisterFn != nullptr)
    {
        // it is not required to use the factory
        inFactoryRegisterFn("DummyMediaPlaybackStatus",
                FactoryMediaPlaybackStatus,
                (CreatorFn)DummyMediaPlaybackStatusCreate);
    }
}

void MediaPlaybackStatusExitPoint()
{
    LOG_UNREGISTER_CONTEXT(aauto_media_pb_status);
}

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    MediaPlaybackStatusEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    MediaPlaybackStatusExitPoint();
}
